/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_linux.c,v 1.5 2004/10/13 20:41:45 nelson Exp $";

/*
 * Linux IOCTL compatability shim
 */

#include <sys/types.h>
#include <sys/param.h>
#include <sys/ioccom.h>
#include <sys/kernel.h>
#include <sys/module.h>
#include <sys/sysproto.h>

#if defined (__amd64__)
#include <machine/../linux32/linux.h>
#include <machine/../linux32/linux32_proto.h>
#else
#include <machine/../linux/linux.h>
#include <machine/../linux/linux_proto.h>
#endif

#include <compat/linux/linux_ioctl.h>
MODULE_DEPEND(mx_linux, linux, 1, 1, 1);
MODULE_DEPEND(mx_linux, mx, 1, 1, 1);

#define MX_LINUX_IOCTL_MIN  0x4d00
#define MX_LINUX_IOCTL_MAX  0x4dff

static linux_ioctl_function_t mx_linux_ioctl;
static struct linux_ioctl_handler mx_linux_handler = 
  {mx_linux_ioctl, MX_LINUX_IOCTL_MIN, MX_LINUX_IOCTL_MAX};

SYSINIT  (mx_linux_register,   SI_SUB_KLD, SI_ORDER_MIDDLE, 
	  linux_ioctl_register_handler, &mx_linux_handler);
SYSUNINIT(mx_linux_unregister, SI_SUB_KLD, SI_ORDER_MIDDLE, 
	  linux_ioctl_unregister_handler, &mx_linux_handler);

static int
mx_linux_ioctl(struct thread *td, struct linux_ioctl_args *args)
{
  unsigned long cmd;

  /* add the "void" bitmask to the ioctl cmd to make it into a valid
     FreeBSD ioctl cmd */

  cmd = (unsigned long)args->cmd;
  cmd |= IOC_VOID;
  args->cmd = (l_uint)cmd;
  
  /* Pass the ioctl off to our standard handler, now that its valid */

  return(ioctl(td, (struct ioctl_args *)args));
}


